/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public final class SettingsManager {
    private static final String RECORD_STORE_NAME = "settings";
    private static final int DEFAULT_CALCULATOR_MODE_ID = 1;
    private static final int LOAN_CALCULATOR_DISPLAYED_FIRST_TIME_ID = 2;
    private static final int LOAN_CALCULATOR_DISPLAYED_FIRST_TIME_TRUE = 0;
    private static final int LOAN_CALCULATOR_DISPLAYED_FIRST_TIME_FALSE = 1;
    private static final SettingsManager instance = new SettingsManager();
    private RecordStore settings = null;
    private int defaultCalculatorMode = 0;
    private boolean loanCalculatorDisplayedFirstTime = true;

    private SettingsManager() {
    }

    public static SettingsManager getInstance() {
        return instance;
    }

    public void init() {
        try {
            this.settings = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            if (this.settings.getNumRecords() == 0) {
                this.settings.addRecord(new byte[]{0}, 0, 1);
                this.settings.addRecord(new byte[]{0}, 0, 1);
            } else {
                byte[] record = this.settings.getRecord(1);
                if (record[0] == 0) {
                    this.defaultCalculatorMode = 0;
                } else if (record[0] == 1) {
                    this.defaultCalculatorMode = 1;
                }
                record = this.settings.getRecord(2);
                if (record[0] == 0) {
                    this.loanCalculatorDisplayedFirstTime = true;
                } else if (record[0] == 1) {
                    this.loanCalculatorDisplayedFirstTime = false;
                }
            }
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.settings != null) {
            try {
                this.settings.closeRecordStore();
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDefaultCalculatorMode(int defaultCalculatorMode) {
        this.defaultCalculatorMode = defaultCalculatorMode;
        try {
            this.settings = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            this.settings.setRecord(1, new byte[]{(byte)defaultCalculatorMode}, 0, 1);
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public int getDefaultCalculatorMode() {
        return this.defaultCalculatorMode;
    }

    public void setLoanCalculatorDisplayedFirstTime(boolean loanCalculatorDisplayedFirstTime) {
        this.loanCalculatorDisplayedFirstTime = loanCalculatorDisplayedFirstTime;
        try {
            if (loanCalculatorDisplayedFirstTime) {
                this.settings.setRecord(2, new byte[]{0}, 0, 1);
            } else {
                this.settings.setRecord(2, new byte[]{1}, 0, 1);
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isLoanCalculatorDisplayedFirstTime() {
        return this.loanCalculatorDisplayedFirstTime;
    }
}

